﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Business" %>
<script runat="server">

    public class PrnParams: ContextBase {
    
        public PrnParams(Context context): base(context) {
            okres = GetOkres();
        }
    
        FromTo okres;
        [Required]
        [Caption("Raport za okres")]
        [Priority(10)]
        public FromTo Okres {
            get { return okres; }
            set {
                if (value == FromTo.Empty)
                    value = GetOkres();
                okres = value;
                OnChanged(EventArgs.Empty);
            }
        }
        
        DefinicjaŚwiadczeniaSocjalnego[] definicja;
        [Caption("Definicja")]
        [Priority(20)]
        public DefinicjaŚwiadczeniaSocjalnego[] Definicja {
            get { return definicja; }
            set {
                definicja = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public object GetListDefinicja() {
            KadryModule kadry = KadryModule.GetInstance(this);
            Soneta.Business.View v = kadry.DefSwiadczSocjal.WgNazwy.CreateView();
            v.Condition &= new FieldCondition.NotEqual("Blokada", true);
            return v;
        }             
            
        FromTo GetOkres() {
            return new YearMonth(ActualDate.Today(Context)).ToFromTo();
        }
    }
    
    PrnParams pars = null;
    [Context(Required=true)]
    public PrnParams Params {
        get { return pars; }
        set { pars = value; }
    }
    
    void OnContextLoad(Object sender, EventArgs args) {
        ArrayList lista = new ArrayList();
        Row[] rows = (Row[])dc[typeof(Row[])];

        RowCondition condition = RowCondition.Empty;
        if (pars.Definicja != null && pars.Definicja.Length > 0)
            condition &= new FieldCondition.In("Definicja", pars.Definicja);
        condition &= new FieldCondition.Contain("Data", pars.Okres);
        
        foreach (Pracownik idx in rows) {
            SubTable st = idx.Module.SwiadczeniaSoc.WgPracownik[idx];
            st = st[condition];
            foreach (SwiadczSocjalne swiadczenie in st)
                lista.Add(swiadczenie);
        }
    
        Grid1.DataSource = lista;
    
        ReportHeader1["DEFINICJA"] = Info("Definicja", "Definicje", (pars.Definicja != null) ? pars.Definicja : new object[] { "(wszystkie)" });
        ReportHeader1["OKRES"] = Info("Za okres", "", pars.Okres.ToString());
    }

    static string Info(string singleLabel, string multiLabel, params object[] lst) {
        if (lst == null || lst.Length == 0)
            return "";
        else if (lst.Length == 1)
            return string.Format("</strong>|{0}: <strong>{1}", singleLabel, lst[0]);
        string info = "";
        foreach (object obj in lst)
            if (info == "")
                info = obj.ToString();
            else
                info += "</strong>, <strong>" + obj.ToString();
        return string.Format("</strong>|{0}: <strong>{1}", multiLabel, info);
    }    
    
</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Badania okresowe</title> 
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form id="BadaniaOkresowe" method="post" runat="server">
        <ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Business.Row[], Soneta.Business"></ea:datacontext>
        <cc1:ReportHeader id="ReportHeader1" title="Zestawienie świadczeń socjalnych|%DEFINICJA%%OKRES%" runat="server"></cc1:ReportHeader>
        <ea:Grid id="Grid1" runat="server" Sort="Pracownik.NazwiskoImię,Nazwa" 
            RowTypeName="Soneta.Kadry.SwiadczSocjalne,Soneta.KadryPlace">
            <Columns>
                <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp."></ea:GridColumn>
                <ea:GridColumn Width="30" DataMember="Pracownik.NazwiskoImię" Caption="Pracownik"></ea:GridColumn>
                <ea:GridColumn Width="20" DataMember="Nazwa" Caption="Rodzaj" NoWrap="True"></ea:GridColumn>
                <ea:GridColumn Width="10" Align="Center" DataMember="Data"></ea:GridColumn>
                <ea:GridColumn Width="14" Align="Right" DataMember="Rozliczenie.Kwota" Caption="Kwota"></ea:GridColumn>
                <ea:GridColumn DataMember="Opis" Caption="Uwagi"></ea:GridColumn>
            </Columns>
        </ea:Grid>
        <cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False">
            <Subtitles>
                <cc1:FooterSubtitle SubtitleType="Empty" Width="50"></cc1:FooterSubtitle>
                <cc1:FooterSubtitle Caption="Podpis pracownika uprawnionego do sporządzenia zestawienia" Width="50"></cc1:FooterSubtitle>
            </Subtitles>
        </cc1:ReportFooter>
    </form>
</body>
</html>
